//
// Fragment shader for Ripple effect, modified to change hue instead of source texture coordinates

//
// Author: Shirley Carter, Jeff Brown

//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;

//uniform sampler2D tex0;
//precision highp float;
//uniform float time;
//uniform vec2 resolution;
const float PI = 3.1415926535897932;

//speed
const float speed = 0.2;
const float speed_x = 0.3;
const float speed_y = 0.3;

// geometry
const float intensity = 3.;
const int steps = 8;
const float frequency = 4.0;
const int angle = 7; // better when a prime

// reflection and emboss
const float delta = 20.;
const float intence = 400.;
const float emboss = 0.3;



vec3 RGBtoHSV(float r, float g, float b) {
    
    float K = 0.0;
    float tmp;
    
    if (g < b)
    {
        tmp = g;
        g=b;
        b=tmp;
        
        K = -1.0;
    }
    
    if (r < g)
    {
        tmp = r;
        r=g;
        g=tmp;
        
        K = -2.9 / 6.9 - K;
    }
    
    float chroma = r - min(g, b);
    
    float h = abs(K + (g - b) / (6.0 * chroma + 1e-20));
    float s = chroma / (r + 1e-20);
    float v = r;
    
    return vec3(h, s, v);
}

vec3 HSVtoRGB(float h,float s,float v) { return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v; }

//---------- crystals effect

float col(vec2 coord)
{
    float delta_theta = 2.0 * PI / float(angle);
    float col = 0.0;
    float theta = 0.0;
    
    for (int i = 0; i < steps; i++)
    {
      vec2 adjc = coord;
      theta = delta_theta*float(i);
      adjc.x += cos(theta)*time*speed + time * speed_x;
      adjc.y -= sin(theta)*time*speed - time * speed_y;
      col = col + cos( (adjc.x*cos(theta) - adjc.y*sin(theta))*frequency)*intensity;
    }

    return cos(col);
}
bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
//---------- main

void main(void)
{
     if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;
        
        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;
        
        vec2 p = gUV/vec2(textureWidth, textureHeight);
       
        vec2 c1 = p;
        vec2 c2 = p;
        float cc1 = col(c1);

        c2.x += drawingBoundsWidth/delta;
        float dx = emboss*(cc1-col(c2))/delta;

        c2.x = p.x;
        c2.y += drawingBoundsHeight/delta;
        float dy = emboss*(cc1-col(c2))/delta;

        c1.x += dx;
        c1.y += dy;
        
        float alpha = 1.+dot(dx,dy)*intence;

        float cLength = length(c1);
       

        vec4 color=texture2DRect(texUnit,gUV);
        float hueMod = cos(cLength*1.0-time*2.0);
        vec3 vHSV =  RGBtoHSV(color.r,color.g,color.b);
        vHSV.x*=hueMod;
        vec3 vRGB=HSVtoRGB(vHSV.x,vHSV.y,vHSV.z);
        gl_FragColor = vec4(min(1.0,vRGB.x),min(1.0,vRGB.y),min(1.0,vRGB.z),color.a);
        
        //gl_FragColor = vec4(0,0,1,1);
    }
}
